/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.core.portal.shape;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1297;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_3532;
import net.minecraft.class_4076;
import org.jetbrains.annotations.Nullable;
import qouteall.imm_ptl.core.IPGlobal;
import qouteall.imm_ptl.core.collision.CollisionHelper;
import qouteall.imm_ptl.core.collision.PortalCollisionHandler;
import qouteall.imm_ptl.core.portal.Portal;
import qouteall.imm_ptl.core.portal.animation.UnilateralPortalState;
import qouteall.imm_ptl.core.portal.shape.PortalShape;
import qouteall.imm_ptl.core.portal.shape.PortalShapeSerialization;
import qouteall.imm_ptl.core.render.ViewAreaRenderer;
import qouteall.q_misc_util.Helper;
import qouteall.q_misc_util.my_util.BoxPredicateF;
import qouteall.q_misc_util.my_util.IntBox;
import qouteall.q_misc_util.my_util.Plane;
import qouteall.q_misc_util.my_util.Range;
import qouteall.q_misc_util.my_util.RayTraceResult;
import qouteall.q_misc_util.my_util.TriangleConsumer;

public final class BoxPortalShape
implements PortalShape {
    public static final BoxPortalShape FACING_OUTWARDS = new BoxPortalShape(true);
    public static final BoxPortalShape FACING_INWARDS = new BoxPortalShape(false);
    public final boolean facingOutwards;

    public static void init() {
        PortalShapeSerialization.addSerializer(new PortalShapeSerialization.Serializer<BoxPortalShape>("box", BoxPortalShape.class, BoxPortalShape::serialize, BoxPortalShape::deserialize));
    }

    private static BoxPortalShape deserialize(class_2487 tag) {
        boolean facingOutwards1 = tag.method_10577("facingOutwards");
        if (facingOutwards1) {
            return FACING_OUTWARDS;
        }
        return FACING_INWARDS;
    }

    public static class_2487 serialize(BoxPortalShape boxShape) {
        class_2487 compoundTag = new class_2487();
        compoundTag.method_10556("facingOutwards", boxShape.facingOutwards);
        return compoundTag;
    }

    private BoxPortalShape(boolean facingOutwards) {
        this.facingOutwards = facingOutwards;
    }

    @Override
    public boolean isPlanar() {
        return false;
    }

    @Override
    public class_238 getBoundingBox(UnilateralPortalState portalState, boolean limitSize, double boxExpand) {
        double halfW = portalState.width() / 2.0 + boxExpand;
        double halfH = portalState.height() / 2.0 + boxExpand;
        double halfT = portalState.thickness() / 2.0 + boxExpand;
        if (limitSize) {
            halfW = Math.min(halfW, 32.0);
            halfH = Math.min(halfH, 32.0);
            halfT = Math.min(halfT, 32.0);
        }
        return Helper.boundingBoxOfPoints(new class_243[]{portalState.transformLocalToGlobal(-halfW, -halfH, -halfT), portalState.transformLocalToGlobal(-halfW, -halfH, halfT), portalState.transformLocalToGlobal(-halfW, halfH, -halfT), portalState.transformLocalToGlobal(-halfW, halfH, halfT), portalState.transformLocalToGlobal(halfW, -halfH, -halfT), portalState.transformLocalToGlobal(halfW, -halfH, halfT), portalState.transformLocalToGlobal(halfW, halfH, -halfT), portalState.transformLocalToGlobal(halfW, halfH, halfT)});
    }

    @Override
    public double roughDistanceToPortalShape(UnilateralPortalState portalState, class_243 pos) {
        class_243 localPos = portalState.transformGlobalToLocal(pos);
        double dx = Helper.getDistanceToRange(-portalState.width() / 2.0, portalState.width() / 2.0, localPos.method_10216());
        double dy = Helper.getDistanceToRange(-portalState.height() / 2.0, portalState.height() / 2.0, localPos.method_10214());
        double dz = Helper.getDistanceToRange(-portalState.thickness() / 2.0, portalState.thickness() / 2.0, localPos.method_10215());
        return Math.sqrt(dx * dx + dy * dy + dz * dz);
    }

    @Override
    @Nullable
    public RayTraceResult raytracePortalShapeByLocalPos(UnilateralPortalState portalState, class_243 localFrom, class_243 localTo, double leniency) {
        class_243 lineVec = localTo.method_1020(localFrom);
        RayTraceResult rayTraceResult = Helper.raytraceAABB(this.facingOutwards, -portalState.width() / 2.0, -portalState.height() / 2.0, -portalState.thickness() / 2.0, portalState.width() / 2.0, portalState.height() / 2.0, portalState.thickness() / 2.0, localFrom.method_10216(), localFrom.method_10214(), localFrom.method_10215(), lineVec.method_10216(), lineVec.method_10214(), lineVec.method_10215());
        return rayTraceResult;
    }

    @Override
    @Nullable
    public Plane getOuterClipping(UnilateralPortalState portalState) {
        return null;
    }

    @Override
    @Nullable
    public Plane getInnerClipping(UnilateralPortalState thisSideState, UnilateralPortalState otherSideState, Portal portal) {
        return null;
    }

    @Override
    public PortalShape getFlipped() {
        if (this.facingOutwards) {
            return FACING_INWARDS;
        }
        return FACING_OUTWARDS;
    }

    @Override
    public PortalShape getReverse() {
        return this.getFlipped();
    }

    @Override
    public boolean roughTestVisibility(UnilateralPortalState portalState, class_243 cameraPos, boolean isIrisShaderOn) {
        boolean in;
        if (isIrisShaderOn) {
            return true;
        }
        class_243 localPos = portalState.transformGlobalToLocal(cameraPos);
        boolean bl = in = localPos.method_10216() > -portalState.width() / 2.0 && localPos.method_10216() < portalState.width() / 2.0 && localPos.method_10214() > -portalState.height() / 2.0 && localPos.method_10214() < portalState.height() / 2.0 && localPos.method_10215() > -portalState.thickness() / 2.0 && localPos.method_10215() < portalState.thickness() / 2.0;
        if (this.facingOutwards) {
            return !in;
        }
        return in;
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void renderViewAreaMesh(class_243 portalOriginRelativeToCamera, UnilateralPortalState portalState, TriangleConsumer vertexOutput, boolean isGlobalPortal) {
        class_243 localHX = portalState.getAxisW().method_1021(portalState.width() / 2.0);
        class_243 localHY = portalState.getAxisH().method_1021(portalState.height() / 2.0);
        class_243 localHZ = portalState.getNormal().method_1021(portalState.thickness() / 2.0);
        ViewAreaRenderer.outputFullQuad(vertexOutput, portalOriginRelativeToCamera.method_1019(localHX), this.facingOutwards ? localHY : localHZ, this.facingOutwards ? localHZ : localHY);
        ViewAreaRenderer.outputFullQuad(vertexOutput, portalOriginRelativeToCamera.method_1020(localHX), this.facingOutwards ? localHZ : localHY, this.facingOutwards ? localHY : localHZ);
        ViewAreaRenderer.outputFullQuad(vertexOutput, portalOriginRelativeToCamera.method_1019(localHY), this.facingOutwards ? localHZ : localHX, this.facingOutwards ? localHX : localHZ);
        ViewAreaRenderer.outputFullQuad(vertexOutput, portalOriginRelativeToCamera.method_1020(localHY), this.facingOutwards ? localHX : localHZ, this.facingOutwards ? localHZ : localHX);
        ViewAreaRenderer.outputFullQuad(vertexOutput, portalOriginRelativeToCamera.method_1019(localHZ), this.facingOutwards ? localHX : localHY, this.facingOutwards ? localHY : localHX);
        ViewAreaRenderer.outputFullQuad(vertexOutput, portalOriginRelativeToCamera.method_1020(localHZ), this.facingOutwards ? localHY : localHX, this.facingOutwards ? localHX : localHY);
    }

    @Override
    public boolean canCollideWith(Portal portal, UnilateralPortalState portalState, class_243 entityEyePos, class_238 entityBoundingBox) {
        class_238 expandedBox = this.getBoundingBox(portalState, false, 2.0);
        return expandedBox.method_994(entityBoundingBox);
    }

    @Override
    public boolean isLocalBoxInPortalProjection(UnilateralPortalState portalState, double minX, double minY, double minZ, double maxX, double maxY, double maxZ) {
        return Range.rangeIntersects(-portalState.width() / 2.0, portalState.width() / 2.0, minX, maxX) && Range.rangeIntersects(-portalState.height() / 2.0, portalState.height() / 2.0, minY, maxY) && Range.rangeIntersects(-portalState.thickness() / 2.0, portalState.thickness() / 2.0, minZ, maxZ);
    }

    @Override
    public class_243 getMovementForPushingEntityOutOfPortal(Portal portal, UnilateralPortalState portalState, class_1297 entity, class_243 attemptedMove) {
        class_238 entityLocalBox = Helper.transformBox(entity.method_5829(), portalState::transformGlobalToLocal);
        class_243 localMove = portalState.transformVecGlobalToLocal(attemptedMove);
        class_238 movedEntityLocalBox = entityLocalBox.method_997(localMove);
        class_238 portalLocalBox = new class_238(-portalState.width() / 2.0, -portalState.height() / 2.0, -portalState.thickness() / 2.0, portalState.width() / 2.0, portalState.height() / 2.0, portalState.thickness() / 2.0);
        class_243 offset = this.facingOutwards ? PortalCollisionHandler.getOffsetForPushingBoxOutOfAABB(movedEntityLocalBox, portalLocalBox, localMove) : PortalCollisionHandler.getOffsetForConfiningBoxInsideAABB(movedEntityLocalBox, portalLocalBox);
        return portalState.transformVecLocalToGlobal(localMove.method_1019(offset));
    }

    @Override
    public PortalShape cloneIfNecessary() {
        return this;
    }

    @Override
    @Nullable
    public class_238 transformEntityActiveCollisionBox(Portal portal, class_238 box, class_1297 entity) {
        class_243 eyePos = entity.method_5836(1.0f);
        UnilateralPortalState thisSideState = portal.getThisSideState();
        class_243 localEyePos = thisSideState.transformGlobalToLocal(eyePos);
        class_238 currBox = box;
        if (currBox != null && localEyePos.method_10216() < -thisSideState.width() / 2.0) {
            currBox = CollisionHelper.clipBox(currBox, thisSideState.transformLocalToGlobal(new class_243(-thisSideState.width() / 2.0, 0.0, 0.0)), thisSideState.transformVecLocalToGlobal(new class_243(-1.0, 0.0, 0.0)));
        }
        if (currBox != null && localEyePos.method_10216() > thisSideState.width() / 2.0) {
            currBox = CollisionHelper.clipBox(currBox, thisSideState.transformLocalToGlobal(new class_243(thisSideState.width() / 2.0, 0.0, 0.0)), thisSideState.transformVecLocalToGlobal(new class_243(1.0, 0.0, 0.0)));
        }
        if (currBox != null && localEyePos.method_10214() < -thisSideState.height() / 2.0) {
            currBox = CollisionHelper.clipBox(currBox, thisSideState.transformLocalToGlobal(new class_243(0.0, -thisSideState.height() / 2.0, 0.0)), thisSideState.transformVecLocalToGlobal(new class_243(0.0, -1.0, 0.0)));
        }
        if (currBox != null && localEyePos.method_10214() > thisSideState.height() / 2.0) {
            currBox = CollisionHelper.clipBox(currBox, thisSideState.transformLocalToGlobal(new class_243(0.0, thisSideState.height() / 2.0, 0.0)), thisSideState.transformVecLocalToGlobal(new class_243(0.0, 1.0, 0.0)));
        }
        if (currBox != null && localEyePos.method_10215() < -thisSideState.thickness() / 2.0) {
            currBox = CollisionHelper.clipBox(currBox, thisSideState.transformLocalToGlobal(new class_243(0.0, 0.0, -thisSideState.thickness() / 2.0)), thisSideState.transformVecLocalToGlobal(new class_243(0.0, 0.0, -1.0)));
        }
        if (currBox != null && localEyePos.method_10215() > thisSideState.thickness() / 2.0) {
            currBox = CollisionHelper.clipBox(currBox, thisSideState.transformLocalToGlobal(new class_243(0.0, 0.0, thisSideState.thickness() / 2.0)), thisSideState.transformVecLocalToGlobal(new class_243(0.0, 0.0, 1.0)));
        }
        return currBox;
    }

    @Override
    @Nullable
    public class_4076 getModifiedVisibleSectionIterationOrigin(Portal portal, class_243 innerCameraPos) {
        if (!IPGlobal.boxPortalSpecialIteration) {
            return null;
        }
        if (!this.facingOutwards) {
            return null;
        }
        InnerSectionRange r = this.getInnerSectionRange(portal);
        class_4076 cameraPosSection = class_4076.method_18680((class_2374)innerCameraPos);
        int secX = class_3532.method_15340((int)cameraPosSection.method_18674(), (int)r.l().method_18674(), (int)r.hInclusive().method_18674());
        int secY = class_3532.method_15340((int)cameraPosSection.method_18683(), (int)r.l().method_18683(), (int)r.hInclusive().method_18683());
        int secZ = class_3532.method_15340((int)cameraPosSection.method_18687(), (int)r.l().method_18687(), (int)r.hInclusive().method_18687());
        return class_4076.method_18676((int)secX, (int)secY, (int)secZ);
    }

    @Override
    public boolean shouldRenderInside(Portal portal, class_238 box) {
        return true;
    }

    private InnerSectionRange getInnerSectionRange(Portal portal) {
        class_238 otherSideBoundingBox = this.getReverse().getBoundingBox(portal.getOtherSideState(), false, 0.0);
        IntBox otherSideIntBox = IntBox.fromRealNumberBox(otherSideBoundingBox);
        class_4076 lSectionPos = class_4076.method_18682((class_2338)otherSideIntBox.l);
        class_4076 hSectionPos = class_4076.method_18682((class_2338)otherSideIntBox.h);
        return new InnerSectionRange(lSectionPos, hSectionPos);
    }

    @Override
    @Nullable
    public BoxPredicateF getInnerFrustumCullingFunc(Portal portal, class_243 cameraPos) {
        if (!IPGlobal.boxPortalSpecialIteration) {
            return null;
        }
        if (!this.facingOutwards) {
            return null;
        }
        InnerSectionRange innerSectionRange = this.getInnerSectionRange(portal);
        float lx = (float)((double)(innerSectionRange.l.method_18674() * 16) - cameraPos.field_1352);
        float ly = (float)((double)(innerSectionRange.l.method_18683() * 16) - cameraPos.field_1351);
        float lz = (float)((double)(innerSectionRange.l.method_18687() * 16) - cameraPos.field_1350);
        float hx = (float)((double)((innerSectionRange.hInclusive.method_18674() + 1) * 16) - cameraPos.field_1352);
        float hy = (float)((double)((innerSectionRange.hInclusive.method_18683() + 1) * 16) - cameraPos.field_1351);
        float hz = (float)((double)((innerSectionRange.hInclusive.method_18687() + 1) * 16) - cameraPos.field_1350);
        return (minX, minY, minZ, maxX, maxY, maxZ) -> {
            float midX = (minX + maxX) / 2.0f;
            float midY = (minY + maxY) / 2.0f;
            float midZ = (minZ + maxZ) / 2.0f;
            return !(midX > lx && midX < hx && midY > ly && midY < hy && midZ > lz && midZ < hz);
        };
    }

    private record InnerSectionRange(class_4076 l, class_4076 hInclusive) {
    }
}

